import { snippetCode } from '@core/components/card-snippet/card-snippet.component';

export const snippetCodeBasic: snippetCode = {
  html: `
<ul class="list-group" dragula="basic-list-group" id="basic-list-group">
  <li class="list-group-item draggable">
    <div class="media">
      <img
        src="assets/images/portrait/small/avatar-s-12.jpg"
        class="rounded-circle mr-2"
        alt="img-placeholder"
        height="50"
        width="50"
      />
      <div class="media-body">
        <h5 class="mt-0">Mary S. Navarre</h5>
        Chupa chups tiramisu apple pie biscuit sweet roll bonbon macaroon toffee icing.
      </div>
    </div>
  </li>
  <li class="list-group-item draggable">
    <div class="media">
      <img
        src="assets/images/portrait/small/avatar-s-1.jpg"
        class="rounded-circle mr-2"
        alt="img-placeholder"
        height="50"
        width="50"
      />
      <div class="media-body">
        <h5 class="mt-0">Samuel M. Ellis</h5>
        Toffee powder marzipan tiramisu. Cake cake dessert danish.
      </div>
    </div>
  </li>
  <li class="list-group-item draggable">
    <div class="media">
      <img
        src="assets/images/portrait/small/avatar-s-2.jpg"
        class="rounded-circle mr-2"
        alt="img-placeholder"
        height="50"
        width="50"
      />
      <div class="media-body">
        <h5 class="mt-0">Sandra C. Toney</h5>
        Sugar plum fruitcake gummies marzipan liquorice tiramisu. Pastry liquorice chupa chupsake
      </div>
    </div>
  </li>
  <li class="list-group-item draggable">
    <div class="media">
      <img
        src="assets/images/portrait/small/avatar-s-3.jpg"
        class="rounded-circle mr-2"
        alt="img-placeholder"
        height="50"
        width="50"
      />
      <div class="media-body">
        <h5 class="mt-0">Cleveland C. Goins</h5>
        Toffee powder marzipan tiramisu. Cake cake dessert danish.
      </div>
    </div>
  </li>
  <li class="list-group-item draggable">
    <div class="media">
      <img
        src="assets/images/portrait/small/avatar-s-4.jpg"
        class="rounded-circle mr-2"
        alt="img-placeholder"
        height="50"
        width="50"
      />
      <div class="media-body">
        <h5 class="mt-0">Linda M. English</h5>
        Chupa chups tiramisu apple pie biscuit sweet roll bonbon macaroon toffee icing.
      </div>
    </div>
  </li>
</ul>
  `
};
export const snippetCodeMultiple: snippetCode = {
  html: `
<div class="col-md-6 col-sm-12">
  <h4 class="my-1">People Group 1</h4>
  <ul dragula="multiple-list-group" class="list-group list-group-flush" id="multiple-list-group-a">
    <li class="list-group-item draggable">
      <div class="media">
        <img
          src="assets/images/portrait/small/avatar-s-12.jpg"
          class="rounded-circle mr-2"
          alt="img-placeholder"
          height="50"
          width="50"
        />
        <div class="media-body">
          <h5 class="mt-0">Mary S. Navarre</h5>
          Chupa chups tiramisu apple pie biscuit sweet roll bonbon macaroon.
        </div>
      </div>
    </li>
    <li class="list-group-item draggable">
      <div class="media">
        <img
          src="assets/images/portrait/small/avatar-s-1.jpg"
          class="rounded-circle mr-2"
          alt="img-placeholder"
          height="50"
          width="50"
        />
        <div class="media-body">
          <h5 class="mt-0">Samuel M. Ellis</h5>
          Toffee powder marzipan tiramisu. Cake cake dessert danish.
        </div>
      </div>
    </li>
    <li class="list-group-item draggable">
      <div class="media">
        <img
          src="assets/images/portrait/small/avatar-s-2.jpg"
          class="rounded-circle mr-2"
          alt="img-placeholder"
          height="50"
          width="50"
        />
        <div class="media-body">
          <h5 class="mt-0">Sandra C. Toney</h5>
          Sugar plum fruitcake gummies marzipan liquorice tiramisu.
        </div>
      </div>
    </li>
    <li class="list-group-item draggable">
      <div class="media">
        <img
          src="assets/images/portrait/small/avatar-s-3.jpg"
          class="rounded-circle mr-2"
          alt="img-placeholder"
          height="50"
          width="50"
        />
        <div class="media-body">
          <h5 class="mt-0">Cleveland C. Goins</h5>
          Toffee powder marzipan tiramisu. Cake cake dessert danish.
        </div>
      </div>
    </li>
    <li class="list-group-item draggable">
      <div class="media">
        <img
          src="assets/images/portrait/small/avatar-s-4.jpg"
          class="rounded-circle mr-2"
          alt="img-placeholder"
          height="50"
          width="50"
        />
        <div class="media-body">
          <h5 class="mt-0">Linda M. English</h5>
          Chupa chups tiramisu apple pie biscuit sweet roll bonbon macaroon.
        </div>
      </div>
    </li>
  </ul>
</div>
<div class="col-md-6 col-sm-12">
  <h4 class="my-1">People Group 2</h4>
  <ul dragula="multiple-list-group" class="list-group list-group-flush" id="multiple-list-group-b">
    <li class="list-group-item draggable">
      <div class="media">
        <img
          src="assets/images/portrait/small/avatar-s-12.jpg"
          class="rounded-circle mr-2"
          alt="img-placeholder"
          height="50"
          width="50"
        />
        <div class="media-body">
          <h5 class="mt-0">Mary S. Navarre</h5>
          Chupa chups tiramisu apple pie biscuit sweet roll bonbon macaroon.
        </div>
      </div>
    </li>
    <li class="list-group-item draggable">
      <div class="media">
        <img
          src="assets/images/portrait/small/avatar-s-1.jpg"
          class="rounded-circle mr-2"
          alt="img-placeholder"
          height="50"
          width="50"
        />
        <div class="media-body">
          <h5 class="mt-0">Samuel M. Ellis</h5>
          Toffee powder marzipan tiramisu. Cake cake dessert danish.
        </div>
      </div>
    </li>
    <li class="list-group-item draggable">
      <div class="media">
        <img
          src="assets/images/portrait/small/avatar-s-2.jpg"
          class="rounded-circle mr-2"
          alt="img-placeholder"
          height="50"
          width="50"
        />
        <div class="media-body">
          <h5 class="mt-0">Sandra C. Toney</h5>
          Sugar plum fruitcake gummies marzipan liquorice tiramisu
        </div>
      </div>
    </li>
    <li class="list-group-item draggable">
      <div class="media">
        <img
          src="assets/images/portrait/small/avatar-s-3.jpg"
          class="rounded-circle mr-2"
          alt="img-placeholder"
          height="50"
          width="50"
        />
        <div class="media-body">
          <h5 class="mt-0">Cleveland C. Goins</h5>
          Toffee powder marzipan tiramisu. Cake cake dessert danish.
        </div>
      </div>
    </li>
    <li class="list-group-item draggable">
      <div class="media">
        <img
          src="assets/images/portrait/small/avatar-s-4.jpg"
          class="rounded-circle mr-2"
          alt="img-placeholder"
          height="50"
          width="50"
        />
        <div class="media-body">
          <h5 class="mt-0">Linda M. English</h5>
          Chupa chups tiramisu apple pie biscuit sweet roll bonbon macaroon.
        </div>
      </div>
    </li>
  </ul>
</div>
  `
};
export const snippetCodeClone: snippetCode = {
  html: `
<div class="row">
  <div class="col-md-6 col-sm-12">
    <h4 class="my-1">Badge Source 1</h4>
    <div dragula="badge-list-copy" class="draggable demo-inline-spacing">
      <div class="badge badge-pill badge-secondary draggable">Youtube</div>
      <div class="badge badge-pill badge-primary draggable">Facebook</div>
      <div class="badge badge-pill badge-success draggable">Google</div>
      <div class="badge badge-pill badge-danger draggable">Instagram</div>
      <div class="badge badge-pill badge-info draggable">Twitter</div>
      <div class="badge badge-pill badge-warning draggable">Discord</div>
    </div>
  </div>
  <div class="col-md-6 col-sm-12">
    <h4 class="my-1">Badge Source 2</h4>
    <div dragula="badge-list-copy" class="draggable demo-inline-spacing">
      <div class="badge badge-pill badge-light-secondary draggable">Github</div>
      <div class="badge badge-pill badge-light-primary draggable">Gitlab</div>
      <div class="badge badge-pill badge-light-success draggable">Slack</div>
      <div class="badge badge-pill badge-light-danger draggable">Pintrest</div>
      <div class="badge badge-pill badge-light-info draggable">Tinder</div>
      <div class="badge badge-pill badge-light-warning draggable">Amazon</div>
    </div>
  </div>
</div>
  `,
  ts: `
  constructor(private dragulaService: DragulaService) {

    dragulaService.createGroup('badge-list-copy', {
      copy: true
    });
  }
  `
};
export const snippetCodeDefault: snippetCode = {
  html: `
<div class="row">
  <div class="col-sm-6">
    <h4 class="my-1">List One</h4>
    <ul dragula="handle-list" class="draggable list-group" id="handle-list-1">
      <li class="list-group-item"><span class="handle">+</span> Cras justo odio</li>
      <li class="list-group-item"><span class="handle">+</span> Dapibus ac facilisis in</li>
      <li class="list-group-item"><span class="handle">+</span> Morbi leo risus</li>
      <li class="list-group-item"><span class="handle">+</span> Porta ac consectetur ac</li>
      <li class="list-group-item"><span class="handle">+</span> Vestibulum at eros</li>
    </ul>
  </div>
  <div class="col-sm-6">
    <h4 class="my-1">List Two</h4>
    <ul dragula="handle-list" class="draggable list-group" id="handle-list-2">
      <li class="list-group-item"><span class="handle">+</span> Cras justo odio</li>
      <li class="list-group-item"><span class="handle">+</span> Dapibus ac facilisis in</li>
      <li class="list-group-item"><span class="handle">+</span> Morbi leo risus</li>
      <li class="list-group-item"><span class="handle">+</span> Porta ac consectetur ac</li>
      <li class="list-group-item"><span class="handle">+</span> Vestibulum at eros</li>
    </ul>
  </div>
</div>
  `,
  ts: `
  import { DragulaService } from 'ng2-dragula';

  constructor(private dragulaService: DragulaService) {

    dragulaService.createGroup('handle-list', {
      moves: function (el, container, handle) {
        return handle.classList.contains('handle');
      }
    });
  }
  `
};
