import { snippetCode } from '@core/components/card-snippet/card-snippet.component';

export const snippetCodeBaseNav: snippetCode = {
  html: `
  <ul class="nav">
    <li class="nav-item">
      <a class="nav-link active" href="javascript:void(0)">Active</a>
    </li>
    <li class="nav-item">
      <a class="nav-link" href="javascript:void(0)">Link</a>
    </li>
    <li class="nav-item">
      <a class="nav-link" href="javascript:void(0)">Link</a>
    </li>
    <li class="nav-item">
      <a class="nav-link disabled" href="javascript:void(0)" tabindex="-1" aria-disabled="true">Disabled</a>
    </li>
  </ul>
  `
};
export const snippetCodeHorizontalNavWithBorder: snippetCode = {
  html: `
  <ul class="nav wrap-border">
    <li class="nav-item">
      <a class="nav-link active" href="javascript:void(0)">Active</a>
    </li>
    <li class="nav-item">
      <a class="nav-link" href="javascript:void(0)">Link</a>
    </li>
    <li class="nav-item">
      <a class="nav-link" href="javascript:void(0)">Link</a>
    </li>
    <li class="nav-item">
      <a class="nav-link disabled" href="javascript:void(0)" tabindex="-1" aria-disabled="true">Disabled</a>
    </li>
  </ul>
  `
};
export const snippetCodeCenterAlignment: snippetCode = {
  html: `
  <ul class="nav justify-content-center">
    <li class="nav-item">
      <a class="nav-link active" href="javascript:void(0)">Active</a>
    </li>
    <li class="nav-item">
      <a class="nav-link" href="javascript:void(0)">Link</a>
    </li>
    <li class="nav-item">
      <a class="nav-link" href="javascript:void(0)">Link</a>
    </li>
    <li class="nav-item">
      <a class="nav-link disabled" href="javascript:void(0)" tabindex="-1" aria-disabled="true">Disabled</a>
    </li>
  </ul>
  `
};
export const snippetCodeEndAlignment: snippetCode = {
  html: `
  <ul class="nav justify-content-end">
    <li class="nav-item">
      <a class="nav-link active" href="javascript:void(0)">Active</a>
    </li>
    <li class="nav-item">
      <a class="nav-link" href="javascript:void(0)">Link</a>
    </li>
    <li class="nav-item">
      <a class="nav-link" href="javascript:void(0)">Link</a>
    </li>
    <li class="nav-item">
      <a class="nav-link disabled" href="javascript:void(0)" tabindex="-1" aria-disabled="true">Disabled</a>
    </li>
  </ul>
  `
};
export const snippetCodeVerticalNav: snippetCode = {
  html: `
  <ul class="nav flex-column">
    <li class="nav-item">
      <a class="nav-link active" href="javascript:void(0)">Active</a>
    </li>
    <li class="nav-item">
      <a class="nav-link" href="javascript:void(0)">Link</a>
    </li>
    <li class="nav-item">
      <a class="nav-link" href="javascript:void(0)">Link</a>
    </li>
    <li class="nav-item">
      <a class="nav-link disabled" href="javascript:void(0)">Disabled</a>
    </li>
  </ul>
  `
};
export const snippetCodeNavWithBorder: snippetCode = {
  html: `
  <ul class="nav flex-column wrap-border">
    <li class="nav-item">
      <a class="nav-link active" href="javascript:void(0)">Active</a>
    </li>
    <li class="nav-item">
      <a class="nav-link" href="javascript:void(0)">Link</a>
    </li>
    <li class="nav-item">
      <a class="nav-link" href="javascript:void(0)">Link</a>
    </li>
    <li class="nav-item">
      <a class="nav-link disabled" href="javascript:void(0)">Disabled</a>
    </li>
  </ul>
  `
};
export const snippetCodeNavWithSquareBorder: snippetCode = {
  html: `
  <ul class="nav flex-column wrap-border square-border">
    <li class="nav-item">
      <a class="nav-link active" href="javascript:void(0)">Active</a>
    </li>
    <li class="nav-item">
      <a class="nav-link" href="javascript:void(0)">Link</a>
    </li>
    <li class="nav-item">
      <a class="nav-link" href="javascript:void(0)">Link</a>
    </li>
    <li class="nav-item">
      <a class="nav-link disabled" href="javascript:void(0)">Disabled</a>
    </li>
  </ul>
  `
};
export const snippetCodeNavWithDivider: snippetCode = {
  html: `
  <ul class="nav flex-column wrap-border">
    <li class="nav-item">
      <a class="nav-link active" href="javascript:void(0)">Active</a>
    </li>
    <li class="nav-item">
      <a class="nav-link" href="javascript:void(0)">Link</a>
    </li>
    <li class="nav-item">
      <a class="nav-link" href="javascript:void(0)">Link</a>
    </li>
    <li class="dropdown-divider"></li>
    <li class="nav-item">
      <a class="nav-link disabled" href="javascript:void(0)">Disabled</a>
    </li>
  </ul>
  `
};
